<?php
// Genel Uygulama Ayarları

// Veritabanı ayarlarını yükle
require_once __DIR__ . '/database.php';

// Uygulama ayarları
if (defined('ENVIRONMENT') && ENVIRONMENT === 'production') {
    // HTTPS protokolünü otomatik algıla
    $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
    define('BASE_URL', $protocol . "://" . $_SERVER['HTTP_HOST']);
    define('APP_DEBUG', false);
} else {
    define('BASE_URL', 'http://localhost/KRMuhasebe/public');
    define('APP_DEBUG', true);
}

// Uygulama bilgileri
define('APP_NAME', 'KESKA Mali Takip Sistemi');
define('APP_VERSION', '1.0.0');

// Dizin yolları
define('ROOT_PATH', dirname(__DIR__));
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('UPLOAD_PATH', PUBLIC_PATH . '/uploads');
define('EXCEL_UPLOAD_PATH', UPLOAD_PATH . '/excel');

// Session ayarları
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', ENVIRONMENT === 'production' ? 1 : 0);

// Timezone
date_default_timezone_set('Europe/Istanbul');

// Türkçe locale
setlocale(LC_TIME, 'tr_TR.UTF-8', 'Turkish');
