<?php
/**
 * AuthController - Kimlik doğrulama işlemleri
 */

class AuthController {
    private $auth;

    public function __construct() {
        $this->auth = new Auth();
    }

    /**
     * Login sayfasını göster
     */
    public function showLogin() {
        // Zaten giriş yapmışsa dashboard'a yönlendir
        if ($this->auth->isLoggedIn()) {
            Helper::redirect('/dashboard');
        }

        require_once __DIR__ . '/../views/auth/login.php';
    }

    /**
     * Login işlemini gerçekleştir
     */
    public function processLogin() {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            Helper::redirect('/login');
        }

        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';

        if (empty($username) || empty($password)) {
            Helper::setFlash('danger', 'Kullanıcı adı ve şifre gereklidir.');
            Helper::redirect('/login');
        }

        if ($this->auth->login($username, $password)) {
            Helper::setFlash('success', 'Hoş geldiniz!');
            Helper::redirect('/dashboard');
        } else {
            Helper::setFlash('danger', 'Kullanıcı adı veya şifre hatalı.');
            Helper::redirect('/login');
        }
    }

    /**
     * Çıkış yap
     */
    public function logout() {
        $this->auth->logout();
        Helper::setFlash('success', 'Başarıyla çıkış yaptınız.');
        Helper::redirect('/login');
    }
}
