<?php
/**
 * ImportController - Excel İçe Aktarma
 * PhpSpreadsheet kullanılacak (Composer ile kurulacak)
 */

class ImportController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index() {
        $auth = $this->auth;
        $pageTitle = 'Excel İçe Aktar';
        $currentPage = 'import';
        require_once __DIR__ . '/../views/import/index.php';
    }

    public function process() {
        // Excel dosyası yükleme ve işleme
        // Şimdilik basit bir mesaj gösterelim
        Helper::setFlash('info', 'Excel import özelliği yakında eklenecek. Şimdilik manuel veri girişi yapabilirsiniz.');
        Helper::redirect('/import');
    }
}
