<?php
class MonthlyPaymentController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index() {
        $sql = "SELECT mp.*,
                (SELECT payment_date FROM monthly_payment_history
                 WHERE monthly_payment_id = mp.id
                 ORDER BY payment_date DESC LIMIT 1) as last_payment_date
                FROM monthly_payments mp
                ORDER BY mp.payment_day ASC, mp.payment_name ASC";
        $payments = $this->db->select($sql);
        $auth = $this->auth;
        $pageTitle = 'Aylık Ödemeler';
        $currentPage = 'monthly-payments';
        require_once __DIR__ . '/../views/monthly-payments/index.php';
    }

    public function create() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'payment_name' => $_POST['payment_name'],
                'category' => $_POST['category'],
                'payment_day' => $_POST['payment_day']
            ];
            $this->db->insert('monthly_payments', $data);
            Helper::setFlash('Ödeme başarıyla eklendi', 'success');
            header('Location: ' . BASE_URL . '/monthly-payments');
            exit;
        }
    }

    public function addHistory() {
        $paymentId = $_GET['id'];
        $amount = $_GET['amount'];
        $date = $_GET['date'];

        $data = [
            'monthly_payment_id' => $paymentId,
            'amount' => $amount,
            'payment_date' => $date,
            'status' => 'paid'
        ];
        $this->db->insert('monthly_payment_history', $data);
        Helper::setFlash('Ödeme kaydı eklendi', 'success');
        header('Location: ' . BASE_URL . '/monthly-payments');
        exit;
    }

    public function history() {
        $paymentId = $_GET['id'];
        $payment = $this->db->selectOne("SELECT * FROM monthly_payments WHERE id = ?", [$paymentId]);
        $history = $this->db->select("SELECT * FROM monthly_payment_history WHERE monthly_payment_id = ? ORDER BY payment_date DESC", [$paymentId]);
        $auth = $this->auth;
        $pageTitle = 'Ödeme Geçmişi';
        $currentPage = 'monthly-payments';
        require_once __DIR__ . '/../views/monthly-payments/history.php';
    }
}
