<?php
class PersonnelSettingsController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index() {
        if ($this->auth->user()['role'] !== 'admin') {
            Helper::setFlash('Bu sayfaya erişim yetkiniz yok', 'danger');
            header('Location: ' . BASE_URL . '/dashboard');
            exit;
        }

        $personnel = $this->db->select("SELECT * FROM personnel WHERE is_active = 1 ORDER BY full_name");
        $auth = $this->auth;
        $pageTitle = 'Personel Maaş Ayarları';
        $currentPage = 'personnel-settings';
        require_once __DIR__ . '/../views/personnel/settings.php';
    }

    public function update() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'monthly_salary' => $_POST['monthly_salary'],
                'daily_meal_fee' => $_POST['daily_meal_fee'],
                'overtime_multiplier' => $_POST['overtime_multiplier'],
                'sunday_multiplier' => $_POST['sunday_multiplier'],
                'holiday_multiplier' => $_POST['holiday_multiplier']
            ];

            $this->db->update('personnel', $data, ['id' => $_POST['personnel_id']]);
            Helper::setFlash('Maaş bilgileri güncellendi', 'success');
            header('Location: ' . BASE_URL . '/personnel-settings');
            exit;
        }
    }
}
