<?php
require_once __DIR__ . '/../includes/autoload.php';
$db = Database::getInstance();

try {
    echo "<h3>Kredi Kartı Dönem Bilgileri Ekleniyor...</h3>";

    $columns = [
        "ALTER TABLE credit_cards ADD COLUMN IF NOT EXISTS card_limit DECIMAL(15,2) DEFAULT 0 AFTER card_number_last4",
        "ALTER TABLE credit_cards ADD COLUMN IF NOT EXISTS current_debt DECIMAL(15,2) DEFAULT 0 AFTER card_limit",
        "ALTER TABLE credit_cards ADD COLUMN IF NOT EXISTS statement_amount DECIMAL(15,2) DEFAULT 0 AFTER current_debt",
        "ALTER TABLE credit_cards ADD COLUMN IF NOT EXISTS minimum_payment DECIMAL(15,2) DEFAULT 0 AFTER statement_amount",
        "ALTER TABLE credit_cards ADD COLUMN IF NOT EXISTS statement_date DATE NULL AFTER minimum_payment",
        "ALTER TABLE credit_cards ADD COLUMN IF NOT EXISTS due_date DATE NULL AFTER statement_date"
    ];

    foreach ($columns as $sql) {
        try {
            $db->getConnection()->exec($sql);
            echo "✅ Sütun eklendi<br>";
        } catch (Exception $e) {
            echo "⚠️ " . $e->getMessage() . "<br>";
        }
    }

    echo "<hr>";
    echo "✅ <strong>Migration tamamlandı!</strong><br>";
    echo "✅ Artık kredi kartlarına dönem bilgileri girebilirsiniz.";
} catch (Exception $e) {
    echo "❌ Genel Hata: " . $e->getMessage();
}
