<?php
/**
 * Kullanıcı kontrolü
 */

require_once __DIR__ . '/../includes/autoload.php';

echo "<h1>Kullanıcı Bilgileri</h1>";

$db = Database::getInstance();

// Tüm kullanıcıları listele
$users = $db->select("SELECT id, username, email, full_name, role, password_hash FROM users");

echo "<table border='1' cellpadding='10'>";
echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Full Name</th><th>Role</th><th>Password Hash (ilk 50 karakter)</th></tr>";

foreach ($users as $user) {
    echo "<tr>";
    echo "<td>" . $user['id'] . "</td>";
    echo "<td>" . $user['username'] . "</td>";
    echo "<td>" . $user['email'] . "</td>";
    echo "<td>" . $user['full_name'] . "</td>";
    echo "<td>" . $user['role'] . "</td>";
    echo "<td>" . substr($user['password_hash'], 0, 50) . "...</td>";
    echo "</tr>";
}

echo "</table>";

echo "<hr>";
echo "<h2>Yeni Şifre Hash'i Oluştur</h2>";

// Test şifreleri için hash'ler
$testPasswords = [
    'password' => password_hash('password', PASSWORD_BCRYPT),
    'admin' => password_hash('admin', PASSWORD_BCRYPT),
    'admin123' => password_hash('admin123', PASSWORD_BCRYPT),
    '123456' => password_hash('123456', PASSWORD_BCRYPT),
];

echo "<p>Test şifre hash'leri (veritabanında güncellemek için):</p>";
echo "<table border='1' cellpadding='10'>";
echo "<tr><th>Şifre</th><th>Hash</th></tr>";

foreach ($testPasswords as $pass => $hash) {
    echo "<tr>";
    echo "<td><strong>$pass</strong></td>";
    echo "<td style='font-size:10px;'>" . $hash . "</td>";
    echo "</tr>";
}

echo "</table>";

echo "<hr>";
echo "<h2>Şifre Güncelleme SQL'leri</h2>";
echo "<p>phpMyAdmin'de şu SQL'lerden birini çalıştırın:</p>";

echo "<pre>";
echo "-- admin kullanıcısının şifresini 'admin123' yap:\n";
echo "UPDATE users SET password_hash = '" . password_hash('admin123', PASSWORD_BCRYPT) . "' WHERE username = 'admin';\n\n";

echo "-- admin kullanıcısının şifresini 'password' yap:\n";
echo "UPDATE users SET password_hash = '" . password_hash('password', PASSWORD_BCRYPT) . "' WHERE username = 'admin';\n";
echo "</pre>";
