<?php
/**
 * Tüm Verileri Temizle
 */

require_once __DIR__ . '/../includes/autoload.php';

echo "<h1>Veritabanı Temizleme</h1>";

$db = Database::getInstance();

// Tüm tabloları temizle
$tables = ['suppliers', 'banks', 'credit_cards', 'monthly_payments', 'monthly_payment_details', 'credit_card_payments', 'bank_transactions'];

foreach ($tables as $table) {
    $db->query("DELETE FROM $table");
    $db->query("ALTER TABLE $table AUTO_INCREMENT = 1");
    echo "<p class='text-success'>✓ $table tablosu temizlendi</p>";
}

echo "<hr>";
echo "<h2 class='text-success'>✓ Tüm Veriler Silindi!</h2>";
echo "<p><a href='import-data.php' class='btn btn-primary'>Şimdi Verileri İçe Aktar</a></p>";
