<?php
require_once __DIR__ . '/../includes/autoload.php';
$db = Database::getInstance();

try {
    // Eski tabloları sil
    $db->getConnection()->exec("DROP TABLE IF EXISTS personnel_payments");
    $db->getConnection()->exec("DROP TABLE IF EXISTS personnel_attendance");
    $db->getConnection()->exec("DROP TABLE IF EXISTS personnel");

    // Yeni tabloları oluştur
    $sql = file_get_contents(__DIR__ . '/../sql/personnel_excel_system.sql');
    $statements = array_filter(array_map('trim', explode(';', $sql)));

    foreach ($statements as $stmt) {
        if (!empty($stmt)) {
            $db->getConnection()->exec($stmt);
        }
    }

    echo "✅ Tablolar yeniden oluşturuldu!<br>";
    echo "✅ Şimdi personelleri ekleyin: <a href='add-personnel.php'>Personel Ekle</a>";
} catch (Exception $e) {
    echo "❌ Hata: " . $e->getMessage();
}
