<?php
require_once __DIR__ . '/../includes/autoload.php';
$db = Database::getInstance();

try {
    echo "<h3>Migration Başlıyor...</h3>";

    // Eski sütunu sil
    try {
        $db->getConnection()->exec("ALTER TABLE personnel DROP COLUMN IF EXISTS daily_wage");
        echo "✅ Eski daily_wage sütunu silindi<br>";
    } catch (Exception $e) {
        echo "⚠️ daily_wage silme hatası (devam ediyoruz): " . $e->getMessage() . "<br>";
    }

    // Yeni sütunları ekle
    $columns = [
        "ALTER TABLE personnel ADD COLUMN IF NOT EXISTS monthly_salary DECIMAL(10,2) DEFAULT 0",
        "ALTER TABLE personnel ADD COLUMN IF NOT EXISTS daily_meal_fee DECIMAL(10,2) DEFAULT 200",
        "ALTER TABLE personnel ADD COLUMN IF NOT EXISTS overtime_multiplier DECIMAL(3,2) DEFAULT 1.00",
        "ALTER TABLE personnel ADD COLUMN IF NOT EXISTS sunday_multiplier DECIMAL(3,2) DEFAULT 1.50",
        "ALTER TABLE personnel ADD COLUMN IF NOT EXISTS holiday_multiplier DECIMAL(3,2) DEFAULT 1.00"
    ];

    foreach ($columns as $sql) {
        try {
            $db->getConnection()->exec($sql);
            echo "✅ Sütun eklendi: " . substr($sql, 0, 80) . "...<br>";
        } catch (Exception $e) {
            echo "❌ Hata: " . $e->getMessage() . "<br>";
        }
    }

    echo "<hr>";
    echo "✅ <strong>Migration tamamlandı!</strong><br>";
    echo "✅ Artık <a href='../personnel-settings'>Maaş Ayarları</a> sayfasını kullanabilirsiniz.";
} catch (Exception $e) {
    echo "❌ Genel Hata: " . $e->getMessage();
}
