-- Aylık Ödemeler Geçmiş Tablosu
-- Her ay farklı tutarda ödemeler için tasarlanmıştır

CREATE TABLE IF NOT EXISTS `monthly_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `monthly_payment_id` int(11) NOT NULL,
  `payment_date` date NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `status` enum('pending','paid','cancelled') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_monthly_payment_id` (`monthly_payment_id`),
  KEY `idx_payment_date` (`payment_date`),
  KEY `idx_status` (`status`),
  CONSTRAINT `fk_monthly_payment` FOREIGN KEY (`monthly_payment_id`) REFERENCES `monthly_payments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
