-- Tedarikci Cek Takibi Tablosu
-- Tedarikciye cek ile yapilan odemeler burada ayri takip edilir.

CREATE TABLE IF NOT EXISTS supplier_checks (
    id INT PRIMARY KEY AUTO_INCREMENT,
    supplier_id INT NOT NULL,
    supplier_transaction_id INT NOT NULL,
    check_number VARCHAR(100) NOT NULL,
    bank_name VARCHAR(100),
    amount DECIMAL(15,2) NOT NULL,
    issue_date DATE NOT NULL,
    due_date DATE NOT NULL,
    status ENUM('BEKLEMEDE', 'TAHSIL_EDILDI', 'IADE') DEFAULT 'BEKLEMEDE',
    description TEXT,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

    UNIQUE KEY unique_supplier_transaction (supplier_transaction_id),
    INDEX idx_due_date (due_date),
    INDEX idx_status (status),
    INDEX idx_supplier (supplier_id),

    FOREIGN KEY (supplier_id) REFERENCES suppliers(id) ON DELETE CASCADE,
    FOREIGN KEY (supplier_transaction_id) REFERENCES supplier_transactions(id) ON DELETE CASCADE,
    FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;
