<?php include __DIR__ . '/../layout/header.php'; ?>

<h2><i class="fas fa-calendar"></i> Ödeme Takvimi</h2>

<div class="card mt-3">
    <div class="card-body">
        <div id="calendar"></div>
    </div>
</div>

<!-- FullCalendar CSS -->
<link href='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.css' rel='stylesheet' />

<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/locales/tr.global.min.js'></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
        locale: 'tr',
        initialView: 'dayGridMonth',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,listMonth'
        },
        buttonText: {
            today: 'Bugün',
            month: 'Ay',
            week: 'Hafta',
            list: 'Liste'
        },
        height: 'auto',
        events: '<?= BASE_URL ?>/api/calendar-events',
        eventClick: function(info) {
            alert('Ödeme: ' + info.event.title + '\nTutar: ' + info.event.extendedProps.amount + '\nDurum: ' + info.event.extendedProps.status);
        },
        eventContent: function(arg) {
            return {
                html: '<div style="padding: 2px 4px; font-size: 11px;">' +
                      '<strong>' + arg.event.title + '</strong><br>' +
                      '<small>' + arg.event.extendedProps.amount + '</small>' +
                      '</div>'
            };
        }
    });

    calendar.render();
});
</script>

<style>
.fc-event {
    cursor: pointer;
}
.fc-event-title {
    font-weight: bold;
}
</style>

<?php include __DIR__ . '/../layout/footer.php'; ?>
