<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="mb-3">
    <a href="<?= BASE_URL ?>/personnel-attendance?month=<?= $year ?>-<?= str_pad($month, 2, '0', STR_PAD_LEFT) ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
</div>

<h2><?= Helper::escape($personnel['full_name']) ?> - Puantaj Düzenle</h2>
<p class="text-muted"><?= date('F Y', strtotime("$year-$month-01")) ?></p>

<style>
.bg-info.bg-opacity-10 { background-color: rgba(13, 202, 240, 0.1) !important; }
.bg-warning.bg-opacity-10 { background-color: rgba(255, 193, 7, 0.1) !important; }
.bg-success.bg-opacity-10 { background-color: rgba(25, 135, 84, 0.1) !important; }
</style>

<div class="card mt-3">
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/personnel-attendance/save">
            <input type="hidden" name="personnel_id" value="<?= $personnel['id'] ?>">
            <input type="hidden" name="period" value="<?= $year ?>-<?= str_pad($month, 2, '0', STR_PAD_LEFT) ?>">

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Çalışan Gün</label>
                    <input type="number" class="form-control" name="calisan_gun" step="0.5" value="<?= $attendance['calisan_gun'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Yıllık İzin</label>
                    <input type="number" class="form-control" name="yillik_izin" step="0.5" value="<?= $attendance['yillik_izin'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Pazar Günü</label>
                    <input type="number" class="form-control" name="pazar_gun" step="0.5" value="<?= $attendance['pazar_gun'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Gün Aşırı Ek Mesai</label>
                    <input type="number" class="form-control" name="gun_asiri_ek_mesai" step="0.5" value="<?= $attendance['gun_asiri_ek_mesai'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Pazar Ek Mesai</label>
                    <input type="number" class="form-control" name="pazar_ek_mesai" step="0.5" value="<?= $attendance['pazar_ek_mesai'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Resmi Tatil Mesai</label>
                    <input type="number" class="form-control" name="resmi_tatil_mesai" step="0.5" value="<?= $attendance['resmi_tatil_mesai'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Yemek Gün</label>
                    <input type="number" class="form-control" name="yemek_gun" step="0.5" value="<?= $attendance['yemek_gun'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">İl Dışı-Gün</label>
                    <input type="number" class="form-control" name="ildisi_gun" step="0.5" value="<?= $attendance['ildisi_gun'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Cep Masraf</label>
                    <input type="number" class="form-control" name="cep_masraf" step="0.01" value="<?= $attendance['cep_masraf'] ?? 0 ?>" min="0">
                </div>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Kaydet
            </button>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
