<?php
$monthParam = $_GET['month'] ?? date('Y-m');
list($year, $month) = explode('-', $monthParam);
$monthNames = ['','Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'];
$monthName = $monthNames[(int)$month];

$totalPayments = 0;
foreach ($payments as $payment) {
    $totalPayments += $payment['amount'];
}
?>
<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="mb-3 d-flex justify-content-between">
    <a href="<?= BASE_URL ?>/personnel-salary?month=<?= $monthParam ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addPaymentModal">
        <i class="fas fa-plus"></i> Ödeme Ekle
    </button>
</div>

<h2><?= Helper::escape($personnel['full_name']) ?> - <?= $monthName ?> <?= $year ?></h2>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h6>Bu Ay Ödenen</h6>
                <h3 class="text-danger"><?= Helper::formatMoney($totalPayments) ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h5>Ödeme Hareketleri</h5>
    </div>
    <div class="card-body">
        <table class="table">
            <thead>
                <tr>
                    <th>Tarih</th>
                    <th>Açıklama</th>
                    <th>Tip</th>
                    <th>Tutar</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($payments)): ?>
                <tr><td colspan="4" class="text-center">Bu ay ödeme kaydı yok</td></tr>
                <?php else: ?>
                    <?php foreach ($payments as $payment): ?>
                    <tr>
                        <td><?= date('d.m.Y', strtotime($payment['payment_date'])) ?></td>
                        <td><?= Helper::escape($payment['description']) ?></td>
                        <td>
                            <?php if ($payment['type'] === 'advance'): ?>
                                <span class="badge bg-warning">Avans</span>
                            <?php elseif ($payment['type'] === 'salary'): ?>
                                <span class="badge bg-success">Maaş</span>
                            <?php else: ?>
                                <span class="badge bg-danger">Kesinti</span>
                            <?php endif; ?>
                        </td>
                        <td><?= Helper::formatMoney($payment['amount']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="addPaymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ödeme Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?= BASE_URL ?>/personnel-salary/addPayment">
                <div class="modal-body">
                    <input type="hidden" name="personnel_id" value="<?= $personnel['id'] ?>">
                    <input type="hidden" name="month" value="<?= $monthParam ?>">
                    <div class="mb-3">
                        <label>Tarih</label>
                        <input type="date" class="form-control" name="payment_date" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label>Ödeme Tipi</label>
                        <select class="form-select" name="type" required>
                            <option value="advance">Avans</option>
                            <option value="salary">Maaş</option>
                            <option value="deduction">Kesinti</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Tutar</label>
                        <input type="number" class="form-control" name="amount" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label>Açıklama</label>
                        <input type="text" class="form-control" name="description" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
