<?php include __DIR__ . '/../layout/header.php'; ?>

<?php
$selectedMonth = $_GET['month'] ?? date('Y-m');
list($selectedYear, $selectedMonthNum) = explode('-', $selectedMonth);
$monthNames = ['','Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'];
$monthName = $monthNames[(int)$selectedMonthNum];
?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h2><i class="fas fa-money-bill-wave"></i> Personel Maaş Yönetimi</h2>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/personnel-settings" class="btn btn-secondary">
            <i class="fas fa-cog"></i> Maaş Ayarları
        </a>
        <input type="month" class="form-control" value="<?= $selectedMonth ?>"
               onchange="window.location.href='<?= BASE_URL ?>/personnel-salary?month=' + this.value"
               style="width: 200px;">
    </div>
</div>

<div class="alert alert-warning">
    <i class="fas fa-lock"></i> <strong>Gizli Bölüm:</strong> Bu sayfayı sadece yöneticiler görüntüleyebilir.
</div>

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i> <strong><?= $monthName ?> <?= $selectedYear ?></strong> dönemi maaş hakediş listesi
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Personel</th>
                        <th>Aylık Maaş</th>
                        <th>Çalışma Günü</th>
                        <th>Toplam Mesai</th>
                        <th>Hakediş</th>
                        <th>Ödenen</th>
                        <th>Bakiye</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($salaryData as $data):
                        $hakedis = $data['hakedis'];
                        $odenen = $data['odenen'];
                        $bakiye = $hakedis - $odenen;
                    ?>
                    <tr>
                        <td><strong><?= Helper::escape($data['full_name']) ?></strong></td>
                        <td><?= Helper::formatMoney($data['monthly_salary']) ?></td>
                        <td><?= number_format($data['total_days'], 1) ?> gün</td>
                        <td><?= number_format($data['total_overtime'], 1) ?> gün</td>
                        <td><strong class="text-primary"><?= Helper::formatMoney($hakedis) ?></strong></td>
                        <td><span class="text-danger"><?= Helper::formatMoney($odenen) ?></span></td>
                        <td>
                            <?php if ($bakiye > 0): ?>
                                <span class="badge bg-success"><?= Helper::formatMoney($bakiye) ?></span>
                            <?php elseif ($bakiye < 0): ?>
                                <span class="badge bg-danger"><?= Helper::formatMoney(abs($bakiye)) ?> (Borç)</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">0,00 ₺</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= BASE_URL ?>/personnel-salary/detail?id=<?= $data['id'] ?>&month=<?= $selectedMonth ?>"
                               class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i> Detay
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
