<?php include __DIR__ . '/../layout/header.php'; ?>

<h2><i class="fas fa-cog"></i> Personel Maaş Ayarları</h2>
<p class="text-muted">Personellerin maaş ve ücret bilgilerini düzenleyin</p>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Personel Adı</th>
                        <th>Aylık Maaş</th>
                        <th>Günlük Yemek</th>
                        <th>Çarpanlar</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($personnel as $p): ?>
                    <tr>
                        <td><strong><?= Helper::escape($p['full_name']) ?></strong></td>
                        <td><?= Helper::formatMoney($p['monthly_salary'] ?? 0) ?></td>
                        <td><?= Helper::formatMoney($p['daily_meal_fee'] ?? 0) ?></td>
                        <td>
                            <small class="text-muted">
                                Gün Aşırı: x<?= $p['overtime_multiplier'] ?? 1 ?> |
                                Pazar: x<?= $p['sunday_multiplier'] ?? 1.5 ?> |
                                Tatil: x<?= $p['holiday_multiplier'] ?? 1 ?>
                            </small>
                        </td>
                        <td>
                            <button class="btn btn-sm btn-primary" onclick="editSalary(<?= $p['id'] ?>)">
                                <i class="fas fa-edit"></i> Düzenle
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Düzenleme Modal -->
<div class="modal fade" id="editSalaryModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Maaş Bilgilerini Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?= BASE_URL ?>/personnel-settings/update">
                <div class="modal-body">
                    <input type="hidden" name="personnel_id" id="edit_personnel_id">

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Aylık Maaş (₺)</label>
                            <input type="number" class="form-control" name="monthly_salary" id="edit_monthly_salary" step="0.01" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Günlük Yemek Ücreti (₺)</label>
                            <select class="form-select" name="daily_meal_fee" id="edit_daily_meal_fee">
                                <option value="0">Yemek Yok</option>
                                <option value="200">200 ₺</option>
                                <option value="225">225 ₺</option>
                            </select>
                        </div>
                    </div>

                    <hr>
                    <h6>Mesai Çarpanları</h6>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Gün Aşırı Mesai Çarpanı</label>
                            <input type="number" class="form-control" name="overtime_multiplier" id="edit_overtime_multiplier" step="0.01" value="1.00">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Pazar Mesai Çarpanı</label>
                            <input type="number" class="form-control" name="sunday_multiplier" id="edit_sunday_multiplier" step="0.01" value="1.50">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Resmi Tatil Mesai Çarpanı</label>
                            <input type="number" class="form-control" name="holiday_multiplier" id="edit_holiday_multiplier" step="0.01" value="1.00">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
const personnelData = <?= json_encode($personnel) ?>;
let editModal;

document.addEventListener('DOMContentLoaded', function() {
    editModal = new bootstrap.Modal(document.getElementById('editSalaryModal'));
});

function editSalary(id) {
    const p = personnelData.find(person => person.id == id);
    if (!p) return;

    document.getElementById('edit_personnel_id').value = p.id;
    document.getElementById('edit_monthly_salary').value = p.monthly_salary || 0;
    document.getElementById('edit_daily_meal_fee').value = p.daily_meal_fee || 200;
    document.getElementById('edit_overtime_multiplier').value = p.overtime_multiplier || 1.00;
    document.getElementById('edit_sunday_multiplier').value = p.sunday_multiplier || 1.50;
    document.getElementById('edit_holiday_multiplier').value = p.holiday_multiplier || 1.00;

    editModal.show();
}
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
